%% Tract-specific analysis of ALS spinal cord data
%  Regents of the University of Minnesota.
% This software is licensed under The MIT License.  
% How to cite: If you use this software for your work, please cite the following paper published in Communications Biology: 
% Pisharady, P.K., Eberly, L.E., Cheong, I. et al. Tract-specific analysis improves sensitivity of spinal cord diffusion MRI 
% to cross-sectional and longitudinal changes in amyotrophic lateral sclerosis. Commun Biol 3, 370 (2020). https://doi.org/10.1038/s42003-020-1093-z.

close all
clear all
load('meanFAs')% For FA etc., this is the file saved by 'als_along_tract_spine_sct.m'
%load('meanAreas')% For CSA, this is the file saved by spine_csa

ALSFRSR_limbplus=[31 33 30 29 36 18 27 26 27 32 30 36 33 34 30 31 15 32 32 32]'; %spinal component of ALSFRS-R (Q4-Q12) 

fa=fa_all; %change this to 'fa_C2' to test correlation at C2
ALSFRSR=ALSFRSR_limbplus;

[r,pval] = corrcoef(ALSFRSR,fa);
pval_corr=pval(1,2)
corr_coiff=r(1,2)

b = regress(ALSFRSR,fa);
b= ALSFRSR'/fa';
yCalc1 = b*fa;

figure
scatter(fa,ALSFRSR)
hold on
plot(fa,yCalc1)
xlabel('Mean FA')
%xlabel('Whole cord cross-sectional area (mm^2) ')
ylabel('ALSFRS-R(Q4-Q12)')
grid on		